/*-------------------------------------------------------------------------
 AppPrint.c

 A FilePrint tool for AppBar.

 by
 GMP van kempen
 NEVERnever Software 1993

 4.00.1  Initial version
 4.00.2	 Added select printer dialog (with thanks to Frits Wiarda)
 4.00.4	 Made "OK" button default push button.

---------------------------------------------------------------------------*/

//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include <shellapi.h>
#include <ctl3d.h>
#include "appprint.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_PUSHBUTTON,b,c,d,e,f)
#define MAKEDEFBUTTON(a,b,c,d,e,f) MAKECHILD("button",a,BS_DEFPUSHBUTTON,b,c,d,e,f)
#define MAKETEXT(a,b,c,d,e,f)	   MAKECHILD("static",a,SS_LEFT,b,c,d,e,f)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU) -1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)

char	    szAppName[] = "AppPrint";
HINSTANCE   hInst;
BOOL	    bPrintFile = FALSE;
HWND hWndButton[3], hWndText[2];


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    int 	Error, xScreen, yScreen, yCaption, xSize, ySize;

    if(!hPrevInstance)
	{
	wndclass.style		    = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(hInstance, szAppName);
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}

    hInst = hInstance;

    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);
    yCaption = GetSystemMetrics(SM_CYCAPTION);

    Ctl3dRegister(hInstance);
    Ctl3dAutoSubclass(hInstance);

    lstrcpy(szBuffer, lpszCmdLine);
    if(strlen(szBuffer))
	{
	bPrintFile = TRUE;
	xSize = ySize = 0;
	}
    else
	{
	xSize = 260;
	ySize = 133 + yCaption;
	}

    hWnd = CreateWindow(szAppName, "AppPrint 4.0",
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			(xScreen - xSize)/2, yScreen/2 - ySize,
			xSize, ySize,
			NULL, (HMENU) NULL, hInstance, NULL);

    if(bPrintFile)
	{
	bPrintFile = TRUE;
	Error = (int) ShellExecute(hWnd, "print", lpszCmdLine, NULL, NULL, NULL);
	if(Error == 31)
	   OkMsgBox("AppPrint 4.0","Could not print.\nNo association found\nfor dropped file.\n");
	}
    else
	{
	ShowWindow(hWnd, SW_SHOWNORMAL);
	UpdateWindow(hWnd);
	}

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInstance);

    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    char *Button[3] = {"&Help","&OK","&Change"};
    char Text[2][256], *szDevice, *szDriver, *szOutput;
    char PrinterName[STRING_SIZE];
    int i, Error, DroppedFiles;
    HBRUSH hbrush;

    switch (message)
	{
	case WM_CREATE:
	    if(bPrintFile)
		SendMessage(hWnd, WM_DESTROY, 0, 0L);
	    else
		{
		// create static frame around text fields
		Ctl3dSubclassCtl(MAKEBORDER(0, 0, 258, 132));
		Ctl3dSubclassCtl(MAKESTATIC(9, 9, 242, 82));
		strcpy(Text[0], "A file print utility for AppBar");
		GetProfileString("windows", "device", "<none>", szBuffer, 255);
		szDevice = strtok(szBuffer, ",");
		szDriver = strtok(NULL, ",");
		szOutput = strtok(NULL, ",");
		sprintf(Text[1], "Default printer:\n%s on %s",szDevice, szOutput);
		hWndButton[0] = MAKEBUTTON(Button[0], 10, 100, 80, 24, IDC_BUTTONS);
		hWndButton[1] = MAKEDEFBUTTON(Button[1], 10+80, 100, 80, 24, IDC_BUTTONS+1);
		hWndButton[2] = MAKEBUTTON(Button[2], 10+160, 100, 80, 24, IDC_BUTTONS+2);
		for(i=0;i<2;i++)
		    hWndText[i] = MAKETEXT(Text[i], 16, 16+i*22, 228, 20*(i+1), IDC_TEXT+i);
		DragAcceptFiles(hWnd, TRUE);
		}
	    return 0;

	case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
	   break;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

       case WM_DROPFILES:
	    DroppedFiles = DragQueryFile((HANDLE) wParam, 0xFFFF, (LPSTR) NULL, 0);
		for(i=0;i<DroppedFiles;i++)
		    {
		    DragQueryFile((HANDLE) wParam, i, szBuffer, sizeof(szBuffer));
		    Error = ShellExecute(hWnd, "print", szBuffer, NULL, NULL, NULL);
		    if(Error == 31)
			OkMsgBox("AppPrint 4.0","Could not print.\nNo association found\nfor dropped file.\n");
		    }
	    DragFinish((HANDLE) wParam);
	    return 0;

       case WM_KEYDOWN:
	    if(wParam == VK_RETURN)
		SendMessage(hWnd, WM_COMMAND, IDC_BUTTONS+1, 0);
	    return 0;

       case WM_COMMAND:
	    switch(wParam)
		{
		case IDC_BUTTONS: /* help */
		    WinHelp(hWnd, "AppTools.hlp",HELP_CONTENTS, 0L);
		    break;

		case IDC_BUTTONS+1:  /* Ok */
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    break;

		case IDC_BUTTONS+2: /* Change */
		    if(SelectPrinterDialog(hInst, hWnd, PrinterName) == 0)
			{
			GetProfileString("devices", PrinterName, "<none>", szBuffer, 255);
			strcat(PrinterName,",");
			strcat(PrinterName,szBuffer);
			WriteProfileString("windows","device", PrinterName);
			szDevice = strtok(PrinterName, ",");
			szDriver = strtok(NULL, ",");
			szOutput = strtok(NULL, ",");
			sprintf(szBuffer, "Default printer:\n%s on %s",szDevice, szOutput);
			Static_SetText(hWndText[1], (LPCSTR) szBuffer);
			}
		    break;
		}
	    break;

       case WM_DESTROY:	// kill the whole program
	    if(bPrintFile)
		DragAcceptFiles(hWnd, FALSE);
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */
