% Script routine to make a bifacial lens
% Expects variables
%   CENTREX
%   CENTREY
%   HEIGHT
%   THICK
%   R1
%   R2
% Creates variables
%   LENS
% Clears variables
%   ARC2
%   VERTEX1
%   VERTEX2
% ------------------------------------------------------
% Create and position the first arc
% ------------------------------------------------------
.quiet_snap 1
.create_surface
.fast_click CENTREX CENTREY
.arcseg
.chord_tan
.+/- HEIGHT
.=> HEIGHT
.fast_click_rel 0 HEIGHT
.R1
.if> 0.0 CONCAVE1
.fast_click_rel +10 HEIGHT
.goto CONT1
:CONCAVE1
.fast_click_rel -10 HEIGHT
:CONT1
.end_element
.=> LENS
.select_object LENS
.object_coordinates LENS 0 tangent
.fast_click X Y
.set_radius R1
.THICK
./ 2
.+/-
.+ CENTREX
.=> VERTEX1
.object_coordinates LENS 0 middle
.move_selection
.fast_click X Y
.fast_click VERTEX1 CENTREY
.unselect_all
% -------------------------------------------------------
% Create and position the second arc
% ------------------------------------------------------
.create_surface
.fast_click CENTREX CENTREY
.arcseg
.0.0
.- HEIGHT
.=> HEIGHT
.fast_click_rel 0 HEIGHT
.R2
.if< 0.0 CONCAVE2
.fast_click_rel -10 HEIGHT
.goto CONT2
:CONCAVE2
.fast_click_rel 10 HEIGHT
:CONT2
.end_element
.=> ARC2
.select_object ARC2
.object_coordinates ARC2 0 tangent
.fast_click X Y
.set_radius R2
.THICK
./ 2
.+ CENTREX
.=> VERTEX2
.object_coordinates ARC2 0 middle
.move_selection
.fast_click X Y
.fast_click VERTEX2 CENTREY
.unselect_all
% --------------------------------------------------------
% Create the segment which will join the arcs
% --------------------------------------------------------
.object_coordinates ARC2 0 end
.create_surface
.end_snap
.fast_click VERTEX1 CENTREY
.fast_click X Y
.end_element
.=> SEGMENT
% --------------------------------------------------------
% Select and join the three surfaces and make a region
% --------------------------------------------------------
.unselect_all
.select_object LENS
.select_object SEGMENT
.select_object ARC2
.join
.make_region
.unselect_all
.clear_var VERTEX1 VERTEX2 ARC2
.return
