//    QIKWAV  -- Quick Windows waveform file playback

// This source is Borland-specific, but there's only one
// nonportable line (the #pragma).  If you don't mind gratuitous
// warning messages, you can just remove the #pragma and you'll
// have a program any compiler should accept.  I compile with
// "bcc -2 -WS".  My DEF file (which I have not provided) specifies
// only the the file description and lets TLINK figure out the rest.
// Hopefully your linker is just as smart.

// QIKWAV does not do any of the register/create/callback stuff.
// In fact, QIKWAV is just a sort of wrapper for sndPlaySound().
// This function first assumes that its first argument is a "sound
// name" entry in [sounds] in win.ini.  If that fails, sndPlaySound()
// assumes the argument is a filename, which it will attempt to open
// and play.  Thus you always want to call QIKWAV with a fully-
// qualified filename argument (such as "qikwav.exe c:\windows\tada.wav").
// This is precisely what will happen if you associate QIKWAV with
// WAV files and then "execute" such a a file from the file manager.

// References:  Microsoft Windows Software Development Kit, Multimedia
// Programmer's Reference.  If you don't have the SDK manual set, the
// Multimedia documentation is available in a commercial edition from
// Microsoft Press.

#include <windows.h>
#include <mmsystem.h>

//Tell Borland compiler WinMain args deliberately ignored.  With
//MS compiler you just leave out the unused variable names.
#pragma argsused

int PASCAL WinMain(HINSTANCE inst, HINSTANCE prev, LPSTR args, int show)
{
	//Pass argument to sndPlaySound()
	if (!sndPlaySound(args, SND_ASYNC | SND_NODEFAULT))
	{
		char buff[256];

		wvsprintf(buff, "Could not play \"%s\" sound file", args);
		MessageBox(NULL, buff, "QikWav Error", MB_ICONEXCLAMATION);
	}
	return 0;
}
