/*   _____________________________________________________________
    /                                                             \
    | File: term.h  - terminator header file
    \_____________________________________________________________/

    contents:

        declarations for

            Terminator Driver
            Whisker (Terminator support class)

    Developers: ID: Name:
    =========== --- -----
                JTH Juergen Thumm
  _____________________________________/VERSION HISTORY\____________________
 /Date_ Who What____________________________________________________________\
 yymmdd --- -----------------------------------------------------------------
 951207 JTH created
*/

//|| Whisker
struct Whisker {
    cpix  pos[2]; // circlic position around mothership
    enum  EFlags {
        MOTHERSIGHTED       = (1<<0),
        ENEMYSIGHTED        = (1<<1),
        ENEMYDIRECTSIGHT    = (1<<2)
        };
    short angle;  // from mothership's sight
    ulong flags;  // EFlags combination
    short mdist;  // mother ship distance
    short edist;  // enemy distance
    short delay;  // in msec 'til next scan

    cpix  shpos[2]; // hit position of last scan() call
    cpix  vdpos[2][4]; // for visual debugging

    Whisker();
    bool  scan(cpix tpos[2], pcol tcol);
    void  reset(void);
    };


//|| TermDriver
class TermDriver : public BikeDriver, public PlayObj {

 public:
    TermDriver(Bike* bike, short PowerPercentage);

    bool accelerate();
    // returns 1 if button 1 pressed

    enum Dirs direction(short *vdir);
    // returns direction to turn to or NONE
    // vdir[] elongation determines if
    // there's acceleration or not

    rcode step(PlayMsg* pm);

    int  specfunc();
    // returns 1 if button 2 pressed

 private:
    Bike *enemy(void);

    rcode selectweapon(enum ObjCodes what);
    // put weapon of type 'what' to front

    void  scanfield(void);
    // scan playfield for target data

    bool  hasweapon(enum ObjCodes what);
    // is weapon of type 'what' available

    short shootDelay;   // shoot delay  in msec

    // this is zeroed in TermDriver ctr:
    struct TargInfo
    {
        Bike *bk;       // bike or NULL
        long  d[3];     // distance
        bool  insight;
        cpix  opos[2];  // obstacle position, if any
    }
    targ[2];            // infos about main bikes

    short itarg;        // currently selected target
    // -1 if none selected
    long  fdiag;        // playfield diameter
    short dirvary;      // direction variation
    short dvdelay;      // delay for this
    long  power;        // percentage from 0 to unlimited
    long  safepower;    // percentage from 0 to 100
    long  revpower;     // reverse power, 100 - safepower

    enum  Actions   {
        FIREMISSILES    = (1<<0),
        RETREAT         = (1<<1),
        PUMPINTOWALL    = (1<<2)
        };
    long action;
    long actioncnt;

    enum  EEnum {
        NDWHISK  = 6,   // number of near distance whiskers
        LDWHISK  = 6,   // number of long distance whiskers
        WHISKERS = NDWHISK + LDWHISK
        };
    Whisker wisk[WHISKERS];
    cpix    ttpos[2];    // temporar target position
    ushort  ttang;       // temporar target angle
    ulong   ttflags;     // what's in sight from it
    short   ttwindex;    // if ttpos matches a whisker, that's it's index
    long    ttdist;      // distance to target
public:
    pcol    enemylscol;  // enemy's lightsword color, for scanning
private:
    short   drawpos[4];

    rcode   stepwhiskers(void);
    rcode   unsetttpos(void);
    bool    willpumpenemyintowall(void);
};

void CreateTerminator(void);
