
;   AMIGA high-performance gfx functions
;   ====================================

;   V 1.3 / 1604941804
;   ==================

;   /1604941804: ytable now ARRAY OF LONGS!!!

    XDEF    _FWriteFatPix

    XREF    _bp         ; bitplane pointer table
    XREF    _nplanes    ; EXACT(!) no. of bitplanes
    XREF    _ytable     ; y lines offset table

_FWriteFatPix

; 16+8(sp).w = D0.w = x pos
; 18+8(sp).w = D1.w = y pos
; 20+8(sp).w = color
; 22+8(sp).w = bytes per line

    Movem.l d2-d5/a2,-(sp)

    movem.w 16+8(sp),d0/d1

    lea     _ytable,a0      ; ytable array base addr
    move.l  4(a0),d5        ; get bytes per line
    asl.l   #2,d1           ; array offset for longs
    move.l  0(a0,d1.w),a2   ; byteoffset = ytable[y]

    move.l  d0,d2   ; get x in d2
    asr.l   #3,d2   ; div 8 for col byte
    adda.l  d2,a2   ; add to byteoffset

    and.l   #7,d0   ; x = x % 8
    move.l  #7,d2
    sub.w   d0,d2
    ext.l   d2
    moveq.l #0,d3
    move.w  _nplanes,d3
    subq.w  #1,d3       ;init dbra counter (FIX /1802941218)
    moveq.l #0,d0

pixloop
    move.w  d3,d0
    asl.l   #2,d0
    lea _bp,a0  ;(a4),a0
    move.l  a2,d1
    move.l  0(a0,d0.w),a1
    add.l   d1,a1

checkcolor
    moveq   #0,d0
    move.w  20+8(sp),d0 ; load color
    btst    d3,d0
    bne setpixel

clearpixel
    bclr    d2,(a1)
    bclr    d2,(a1,d5.w)    ;one further pixel down

    move    d2,d4           ;one further pixel right
    subq.w  #1,d4
    bmi.s   clearpx2
    bclr    d4,(a1)
    bclr    d4,(a1,d5.w)    ;and down
    bra.s   clearpxc
clearpx2
    bclr    #7,1(a1)
    bclr    #7,1(a1,d5.w)   ;and down

clearpxc
    dbra    d3,pixloop
    movem.l (sp)+,d2-d5/a2
    rts

setpixel
    bset    d2,(a1)
    bset    d2,(a1,d5.w)    ;further pix down

    move    d2,d4           ;further pix right
    subq.w  #1,d4
    bmi.s   setpx2
    bset    d4,(a1)
    bset    d4,(a1,d5.w)    ;and down
    bra.s   setpxc
setpx2
    bset    #7,1(a1)
    bset    #7,1(a1,d5.w)   ;and down

setpxc
    dbra    d3,pixloop
    movem.l (sp)+,d2-d5/a2
    rts
