#   ifndef  _EXP_IRQ_H_
#   define  _EXP_IRQ_H_ 80

/*
  0702941432 <- last update (yymmddhh'')
     _____________________________________________________________
    /                                                             \ 
    | Module:       expirq.h - CRITICAL INTERRUPT SERVICES
    \_____________________________________________________________/

    Description:    read notes in expirq.cpp

    Refers to:      expirq.h
    Used by:        everywhere

    Developers: ID: Name:
    =========== --- -----
                JTH Juergen Thumm
  _____________________________________/VERSION HISTORY\____________________
 /Date_ Version Who What____________________________________________________\ 
 yymmdd ------- --- ---------------------------------------------------------
 940914 0.80    JTH created from file 'misc.h'
*/

#   include "expdef.h"
#   include "explib.h"
#   include "misc.h"

/*   _____________________________________________________________
    /                                                             \ 
    | High Resolution Timer
    \_____________________________________________________________/ 

    Descriptn:  timer with millisecond resolution

    Implementd: Amiga

    Notes:      interface is portable,
                but implementation is very(!) hardware dependent

  _____________________________________/VERSION HISTORY\____________________  
 /Date_ Version Who What____________________________________________________\ 
 yymmdd ------- --- --------------------------------------------------------- 
 940213 0.100   JTH created

 940908 0.500   JTH ported to Windows 3.1; currently supports just ONE usage
                    of a timer at a time
*/

//|| FineTimer 

class FineTimer {

#ifdef  WIN16

    //  rcode   FineTimer::IRQ_set();
    //  static void FineTimer::IRQ_restore();

    //  hardware timer x starts to countdown from a fix value k,
    //  e.g. 27.777 msec. User selects another period size u.
    //  the following is the difference k - u:

    uchar   tstart;
    uword   tlen;

#endif

 public:

#ifdef  WIN16
    FineTimer();
    ~FineTimer();
#endif

    // let timer begin to countdown a specified number of msec's
    void beginperiod(long msec);    // msec MAXIMUM: 22

    // every period must be ended by:
    //
    //      endperiod()
    //
    // ... never call a further beginperiod() before you
    //     ended the current period!
    //
    // you may call waitforperiodend() several times in one period

    void endperiod();

    // how many msec's are currently remaining in the timer?
    intf remain();

    // wait until timer started by beginperiod() has run low;
    // if it ran low meanwhile, this returns immediately
    void waitforperiodend();

    // delay EXACTLY for a specified number of MILLISECONDS
    void delay(long msec);      // msec: unlimited

    };

#endif  // included