(**************************************************)
(*                                                *)
(*   Unit CTL3D                                   *)
(*                                                *)
(*   for use with CTL3D.DLL from Microsoft        *)
(*                                                *)
(*   submitted by Andreas Furrer                  *)
(*                                                *)
(**************************************************)

unit Ctl3D;

interface

uses WinTypes;

const Ctl3d_Buttons      = $0001;
      Ctl3d_Listboxes    = $0002;
      Ctl3d_Edits        = $0004;
      Ctl3d_Combos       = $0008;
      Ctl3d_StaticTexts  = $0010;
      Ctl3d_StaticFrames = $0020;
      Ctl3d_All          = $ffff;

function Ctl3dGetVer : word;
function Ctl3dSubclassDlg(HWindow : HWnd; GrBits : word) : bool;
function Ctl3dSubclassCtl(HWindow : HWnd) : bool;
function Ctl3dCtlColor(DC : HDC; Color : TColorRef) : HBrush; {ARCHAIC, use Ctl3dCtlColorEx}
function Ctl3dEnabled : bool;
function Ctl3dColorChange : bool;
function Ctl3dRegister(Instance : THandle) : bool;
function Ctl3dUnregister(Instance : THandle) : bool;
function Ctl3dAutoSubclass(Instance : THandle) : bool;
function Ctl3dCtlColorEx(Message, wParam : word; lParam : longint) : HBrush;


implementation

function Ctl3dGetVer;       external 'Ctl3d' index 1;
function Ctl3dSubclassDlg;  external 'Ctl3d' index 2;
function Ctl3dSubclassCtl;  external 'Ctl3d' index 3;
function Ctl3dCtlColor;     external 'Ctl3d' index 4;
function Ctl3dEnabled;      external 'Ctl3d' index 5;
function Ctl3dColorChange;  external 'Ctl3d' index 6;
function Ctl3dRegister;     external 'Ctl3d' index 12;
function Ctl3dUnregister;   external 'Ctl3d' index 13;
function Ctl3dAutoSubclass; external 'Ctl3d' index 16;
function Ctl3dCtlColorEx;   external 'Ctl3d' index 18;

end.
