/*  Project filter
		DCS, UP Olomouc
		Copyright  1995. All Rights Reserved.

		SUBSYSTEM:    filter.exe Application
		FILE:         matrix.h
		AUTHOR:       Robert Batusek

		deklarace datovych struktur potrebnych k filtraci

		declaration of data structures needed to filtering
*/

#include <complex.h>

#define Complex complex

#ifndef _matrix_h
#define _matrix_h

typedef unsigned char Element;
typedef signed char SignedElement;

#ifndef BOOL
	typedef int BOOL;
	#define TRUE 1
	#define FALSE 0
#endif

enum TDirection {Middle,North,South,East,West,NorthEast,NorthWest,SouthEast,SouthWest};



/////////////////////////////////////////////////
// class Complex
// -------------
// Popis: zakladni operace s komplexnimi cisly
// Description: basic operations with complex numbers
//
/*class Complex {
	public:
		Complex();
		Complex(double real,double imag = 0);
		Complex(Complex &c);

		double Real(){return re;}
		double Imaginary(){return im;}

		void SetNumber(double real,double imag = 0);

		Complex operator +=(Complex &);
		Complex operator+(Complex &);
		Complex operator-(Complex &);
		Complex operator*(Complex &);
		Complex operator*(double);

		Complex operator=(Complex &);

	protected:
		double re,im;
};*/


/////////////////////////////////////////////////
// class TMatrix
// -------------
// Popis: matice pro ulozeni obrazovych dat
// Description: matrix for storing picture data
//
class TMatrix {
	public:
		TMatrix(int x,int y);
		TMatrix(TMatrix &m);
		virtual ~TMatrix();

		void Allocate(int x,int y);
		void SetElement(int x,int y,Element);
		Element GetElement(int x,int y);
		void GetSize(int &x,int &y);
		BOOL Resize(int newxsize, int newysize, BOOL KeepOldValues = FALSE);

	protected:
		int xsize,ysize;
		Element far **data;
};

/////////////////////////////////////////////////
// class TMask
// -------------
// Popis: matice pro ulozeni filtracni masky
// Description: matrix for storing filter mask
//
class TMask: public TMatrix {
	public:
		TMask(int x,int y,int value = 1,int div = 0);

		void FillRect(int ltx,int lty, int rbx,int rby,int value = 1);
		int Divisor(){return divisor;}
		virtual void CalculateDivisor();
	protected:
		int divisor;
};

/////////////////////////////////////////////////
// class TRotatingMask
// -------------
// Popis: rotujici maska v okoli 5x5
// Description: rotating mask in 5x5 environs
//
class TRotatingMask: public TMask {
	public:
		TRotatingMask();

		void SetDirection(TDirection newdirection);

	protected:
		TDirection direction;
};

/////////////////////////////////////////////////
// class TComplexMatrix
// -------------
// Popis: matice pro praci s komplexnimi cisly (viz. TComplexFilter)
// Description: matrix for work with complex numbers (see TComplexFilter)
//
class TComplexMatrix : public TMatrix {
	public:
		TComplexMatrix(int x,int y);
		TComplexMatrix(TMatrix &m);
		TComplexMatrix(TComplexMatrix &m);
		~TComplexMatrix();

		virtual void Allocate(int x,int y);
		void ConvertComplexToBMP();
		void MoveComplexToBMP();
		void SetComplex(int x,int y,Complex value)
			{complexdata[x][y]=value;}
		Complex GetComplex(int x,int y)
			{return complexdata[x][y];}

	protected:
		Complex far **complexdata;
};
#endif
