/*--------------------------- EIKONA.H ------------------------------------*/

/*EIKONA v.2.0 Last revision  22-9-94, I. Pitas	*/

/*-------------------------------------------------------------------------*/

/*#include "windows.h"*/

typedef unsigned char far* far* image;

typedef float far* far* matrix;

typedef int far* far* imatrix;

typedef float far* vector;



/* Type definitions for edge following algorithms */

typedef struct pixel {int row; int column; int cost;} CPIXEL;

/*typedef struct pixel CPIXEL;*/

typedef struct node { CPIXEL info; struct node far* link;} NODE;

/*typedef struct node NODE;*/



/* Type definitions for chain codes */

typedef unsigned char byte;

typedef struct CHNODE {unsigned char num; struct CHNODE *next;} CHNODE;

typedef struct CHAIN {CHNODE *start; CHNODE *end;} CHAIN;



/* Type definitions for polygon approximations */

typedef struct PIXEL {int x; int y;} PIXEL;

typedef struct LNODE {PIXEL num; struct LNODE *next;} LNODE;

typedef struct LIST {LNODE *start; LNODE *end;} LIST;



/* Type definitions for quadtrees */

typedef struct QNODE { unsigned char color;

              struct QNODE *father;

              struct QNODE *quad[4];

             } QNODE;



typedef image far* pyramid;



/* Type definitions for Huffman coding */

typedef struct symbol far* SPOINTER;



struct symbol {

           float prob;

           SPOINTER comp[2];

          };





/* Type definitions for LZW coding */

typedef struct llink far*LPOINTER;

struct llink {

 int n;

 LPOINTER next;

};



/*-------------------------------------------------------------------------*/

/* Global variables used in EIKONA, internal use only                      */



int NMAX, MMAX, INMAX, IMMAX, FNMAX, FMMAX ,NWMAX, MWMAX, NSIG;





/*-------------------------------------------------------------------------*/

/*Windows additions. Subroutines in win20.c */

/*image  win_build_image(PHANDLE,int,int,int);

void win_freeuc2(PHANDLE,int);

matrix win_build_matrix(PHANDLE,int,int,int);

void win_freef2(PHANDLE,int);

imatrix win_build_imatrix(PHANDLE,int,int,int);

void win_freei2(PHANDLE,int);

int wincolorimdisp(HWND,LOGPALETTE *,int,image,image,image,int,int,int,int,int,int);

int winbwimdisp(HWND,LOGPALETTE *,image,int,int,int,int,int,int);

int refresh(int buffer,unsigned char display_type); */



/*-------------------------------------------------------------------------*/

/* Subroutines in build20.c                                                */





int init_eikona(int,int,int,int,int);

image  build_image(int,int);

vector build_vector(int);

matrix build_matrix(int,int);



unsigned char far* far* matuc2(unsigned int, unsigned int); /* internal use*/

float far* far* matf2(unsigned int, unsigned int);   /* internal use only */

void mfreeuc2(unsigned char far* far*,unsigned int); /* internal use only */

void mfreef2(float far* far*,unsigned int);          /* internal use only */

int far* far* matin2(unsigned int,unsigned int);

void mfreein2(int far* far*,unsigned int);

int far* far* build_imatrix(int,int);



/*-------------------------------------------------------------------------*/

/* Subroutines in bas20.c                                                  */



int add(image,image,image, int,int,int,int);

int addc(image,image, int, int,int,int,int);

int and(image,image,image, int,int,int,int);

int bin(image, int,int,int,int);

int clear(image, int, int,int,int,int);

int clearmatrix(matrix, float, int,int,int,int);

int clip(image,image, int,int, int,int,int,int);

int copy(image,image, int,int, int,int,int,int);

int copymatrix(matrix, matrix, int,int, int,int,int,int);

int diff(image,image,image, int,int,int,int);

int image2matrix(image, matrix, int,int, int,int,int,int);

int matrix2image(matrix, image, int,int, int,int,int,int);

int mix(image,image,image, float,float, int,int,int,int);

int multc(image,image, float, int,int,int,int);

int neg(image,image, int,int,int,int);

int nltran(image,image, vector, int,int,int,int);

int not(image,image, int,int,int,int);

int or(image,image,image, int,int,int,int);

int overmix(image,image,image,image, int,int,int,int);

int pixr(image, int,int);

int pixw(image, int,int, int);

int rotim(image,image, float, int,int, int,int, int,int,int,int);

int thres(image,image, int, int,int,int,int);

int xor(image,image,image, int,int,int,int);



/*-------------------------------------------------------------------------*/

/* Subroutines in io20.c                                                   */



int dump(image, char *, int,int,int,int);

int dump_signal(vector, char *);

int fromdisk(char *, image, int,int, int,int);

int printim(image, char *, int,int,int,int);

int todisk(image, char *, int,int,int,int);

int loadmatrix(char *, matrix, int,int, int,int);

int savematrix(matrix, char *, int,int,int,int);

int print_hp(image, char*,int,int,int,int,int,int,int);

int fromtga(char*,image,image,image,int,int,int,int, int*, int*);

int totga(image,image,image,char*,int,int,int,int,unsigned char);



int print_chain(CHAIN);

int fprint_chain(char *,int,int,CHAIN);

int print_list(LIST);

int fprint_list(char *,int,int,LIST);



/* Definitions for TIFF files */

#define TRUE  1

#define FALSE 0

#define _II_  1

#define _MM_  0



unsigned long *StripAddresses,*ByteCounts;



struct IFH {

  unsigned int   ByteOrder;

  unsigned int   Version;

  unsigned long  FirstIfdOffset;

  struct IFD     *Ifd;  /* Image File Directories are described as a list */

};



struct IFD {

  unsigned int      Nfields;

  struct IFDentry  *Entries;

  unsigned long     NextOffset;

  struct IFD       *NextIfd; /* pointer to the next IFD */

};



struct IFDentry {

  unsigned int    Tag;

  unsigned int    Type;

  unsigned long   Length;

  unsigned long   Value;

};



enum{iWidth,iLength,iBits,iCompression,iSoffsets,iSamples,iRows,iSbytes,iXRes,

     iYRes};



static struct IFD    *read_ifd();

static struct IFD    *create_ifd();

static unsigned int   read_word();

static unsigned long  read_long();

int find_StripParameters();

int fromtiff(FILE *,image,int,int,int *,int *);



static struct IFD    *make_ifd();

static struct IFD    *create_ifd();

static unsigned int  reverse_word();

static unsigned long reverse_long();

static int           write_ifdentry();

static unsigned char pack_in_byte();

static int           get_datetime();

int totiff(image,FILE *,int,int,int,int,int,int,int,char*,char*,char*);



/*-------------------------------------------------------------------------*/

/* Subroutines in disp20.c                                                 */



int getvideomode(void);                       /* internal use only */



int bindisp(image, int, int,int, int,int,int,int);

int clearscreen(void);

int imdisp(image, int, int,int, int,int,int,int);

int init_graphics(char *);

int overdisp(image,image, int, int,int, int,int,int,int);

int reset_graphics(void);

int sigshow(vector, int, int,int, int,int);



int coeff(vector, int);

int two_d_coeff(matrix, int,int);



/* Subroutines in assemply                                                */

int disp13(image, int, int,int, int,int,int,int);

int dispb13(image, int, int,int, int,int,int,int);

int disp10(image, int, int,int, int,int,int,int, int);

int dispb10(image, int, int,int, int,int,int,int, int);



int vgadisp(image,int,int,int,int,int,int);

int video_mode(unsigned char);

int extvgadisp(image,int,int,int,int,int,int,int);

int extdisp(image,int,int,int,int,int,int,int);

int extbindisp(image,unsigned char,int,int,int,int,int,int,int);

unsigned long far* build_palette();

int load_palette(unsigned long far*);

int default_palette(unsigned long far*,int);

int create_palette(image,image,image,unsigned long far*,int,int,int,int);

int rgbtovga(image,image,image, image, unsigned long far*, int,int,int,int,int);



int view_pyramid(pyramid,int,int);



/*-------------------------------------------------------------------------*/

/* Subroutines in color20.c                                                */



int cieRGB_to_XYZ(image,image,image,image,image,image,int,int,int,int);

int XYZ_to_cieRGB(image,image,image,image,image,image,int,int,int,int);

int XYZ_to_ciexyY(image,image,image,matrix,matrix,matrix,int,int,int,int);

int ciexyY_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);

int XYZ_to_cieuvY(image,image,image,matrix,matrix,matrix,int,int,int,int);

int cieuvY_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);

int XYZ_to_cieUVW(image,image,image,matrix,matrix,matrix,int,int,int,int);

int cieUVW_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);

int XYZ_to_cieUsVsWs(image,image,image,matrix,matrix,matrix,int,int,int,int);

int cieUsVsWs_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);

int XYZ_to_SthetaWs(image,image,image,matrix,matrix,matrix,int,int,int,int);

int SthetaWs_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);

int XYZ_to_Lsasbs(image,image,image,matrix,matrix,matrix,int,int,int,int);

int Lsasbs_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);

int XYZ_to_Lsusvs(image,image,image,matrix,matrix,matrix,int,int,int,int);

int Lsusvs_to_XYZ(matrix,matrix,matrix,image,image,image,int,int,int,int);



ntscRGB_to_XYZ(image,image,image,image,image,image,int,int,int,int);

XYZ_to_ntscRGB(image,image,image,image,image,image,int,int,int,int);

ntscRGB_to_YIQ(image,image,image,image,image,image,int,int,int,int);

YIQ_to_ntscRGB(image,image,image,image,image,image,int,int,int,int);

RGB_to_CMY(image,image,image,image,image,image,int,int,int,int);

CMY_to_RGB(image,image,image,image,image,image,int,int,int,int);

RGB_to_CMYK(image,image,image,image,image,image,image,int,int,int,int);

CMYK_to_RGB(image,image,image,image,image,image,image,int,int,int,int);



int RGB_to_HSI(image,image,image,matrix,matrix,matrix,int,int,int,int);

int HSI_to_RGB(matrix,matrix,matrix,image,image,image,int,int,int,int);

int RGB_to_HSV(image,image,image,matrix,matrix,matrix,int,int,int,int);

int HSV_to_RGB(matrix,matrix,matrix,image,image,image,int,int,int,int);

int RGB_to_HLS(image,image,image,matrix,matrix,matrix,int,int,int,int);

int HLS_to_RGB(matrix,matrix,matrix,image,image,image,int,int,int,int);



static double value(double,double,double);

double atan3(double,double);



/*-------------------------------------------------------------------------*/

/* Subroutines in trans20.c                                                */



int arpsd(image,matrix,int,int,int,int,int);

int blackman_tukey_psd(image,matrix,int,int,int,int);

int convolution(matrix,matrix, matrix, int,int, int,int,int,int);

int correlation(matrix,matrix, matrix, int,int, int,int,int,int);

int fft1d(float *, float *,int,float *, float *); /* internal use */

int fft2d(matrix,matrix, matrix,matrix, int, int,int, int,int,int,int);

int fft2image(matrix,matrix, image, int,int, int,int,int,int);

int magnphase2reim(matrix,matrix, matrix,matrix, int,int, int,int,int,int);

int pt(matrix,matrix,int,int);

int ptfft(matrix,matrix,int,int,int);

int reim2magnphase(matrix,matrix, matrix,matrix, int,int, int,int,int,int);

int windowcorrel(matrix,matrix,int,int,int,int);



int fft_IO_mc(FILE *, FILE *,int,int,int,int);

int fft_IO_trans(FILE *,FILE *,int,int);

int real_2d_fft(matrix,int,int);

int refft2images(matrix,matrix,int,int);

int fft(float *,float*,int,float *, float *,int); /* internal use only */

int init(vector,vector,int);

int DCT(matrix,vector,vector,int,int);

int IDCT(matrix,vector,vector,int,int);

int fftc(vector,vector,int,int); /*internal use*/



/*-------------------------------------------------------------------------*/

/* Subroutines in filt20.c                                                 */



int cdfhist(vector, vector);

int conv(image,image, matrix, int,int, int,int,int,int);

int decim(image,image, int, int,int, int,int,int,int);

int dither(image,image,int,int,int,int,int);

int halftone(image,image, int, int,int,int,int);

int hist(image, vector, int,int,int,int);

int histeq(image,image, vector, int,int,int,int);

int L2_error_norm(image,image,float*,int,int,int,int);

int L2_error_ratio(image,image,image,image,float*,int,int,int,int);

int l_filter(image,image, vector, int,int, int,int,int,int);

int maxi(image,image, int,int, int,int,int,int);

int median(image,image, int,int, int,int,int,int);

int mini(image,image, int,int, int,int,int,int);

int movav(image,image, int,int, int,int,int,int);

int noise_add_gauss(image,image, float, int,int,int,int);

int noise_add_laplace(image,image, float, int,int,int,int);

int noise_add_uni(image,image, float, int,int,int,int);

int noise_imp(image,image, float, int,int, int,int,int,int);

int noise_mult_gauss(image,image, float, int,int,int,int);

int noise_mult_uni(image,image, float, int,int,int,int);

int order(image,image, int, int,int, int,int,int,int);

float rand0(int *);        /* internal use only */

int sort(int far *, int); /* internal use only */

int sharp(image,image, int,int,int,int);

int snr(image,image,float *,int,int,int,int);

int zoom(image,image, int, int,int, int,int,int,int);



overlap_add(matrix,matrix,matrix,int,int,int,int,int,int,int,int);

overlap_add_c(matrix,matrix,matrix,matrix,matrix,matrix,int,int,int,int,int,int,int,int);

overlap_save(matrix,matrix,matrix,int,int,int,int,int,int,int,int);

overlap_save_c(matrix,matrix,matrix,matrix,matrix,matrix,int,int,int,int,int,int,int,int);

/*int wienerfrequency(matrix,matrix,matrix,matrix,matrix,float,int,int);*/



/*-------------------------------------------------------------------------*/

/* Subroutines in nlfilt20.c                                                 */

/* Warnings unresolved!!!!!!!!!!!!!



int adapt_l_filter(image,image,image,vector,float,int,int,int,int,int,int);

int adapt_wei_median(image,image,int,float,int,int,int,int,int,int);

int a_trimmed_filt(image,image,int,int,int,int,int,int,int);

int bclose(image,image,image,int,int,int,int,int,int);

int bdilate(image,image,int,int,int,int,int);

int berode(image,image,int,int,int,int,int);

int bopen(image,image,image,int,int,int,int,int,int);

int dw_mtm(image,image,int,int,int,int,int,int,int,int,int);

int harm_filt(image,image,matrix,int,int,int,int,int,int);

int homom_filt(image,image,matrix,int,int,int,int,int,int);

int imclose(image,image,image,image,int,int,int,int,int,int);

int imdilate(image,image, image, int,int, int,int,int,int);

int imerode(image,image, image, int,int, int,int,int,int);

int imopen(image,image,image,image,int,int,int,int,int,int);

int Lp_filt(image,image,float,matrix,int,int,int,int,int,int);

int local_adapt_filt(image,image,float,int,int,int,int,int,int);

int max_median(image,image,int,int,int,int,int,int);

int medhybr(image,image,int,int,int,int,int,int);

int mnn(image,image,int,int,int,int,int,int,int);

int msd(image,image,image,image,int,int,int,int,int,int);

int mtm(image,image,int,int,int,int,int,int,int);

int mult_adapt_filt(image,image,float,int,int,int,int,int,int);

int multistage_median(image,image,int,int,int,int,int,int);

int optimal_L_filter(image,vector,int,int,int,int,int,int);

int rec_median(image,image,int,int,int,int,int,int);

int run_max(image,image,image,int,int,int,int,int,int);

int run_median(image,image,int,int,int,int,int,int);

int run_min(image,image,image,int,int,int,int,int,int);

int sam(image,image,float,float,float,float,float,int,int,int,int,int,int,int,int,int,int,int,int);

int sep_median(image,image,image,int,int,int,int,int,int);

int skeleton(image,image,image,image,int,int,int,int,int);

int top_hat(image,image,image,int,int,int,int,int,int);

int wei_median(image,image,image,int,int,int,int,int,int); */



/*-------------------------------------------------------------------------*/

/* Subroutines in code20.c                                                 */



int treeaccess(SPOINTER,int *,char *,struct symbol far*,

        unsigned char far* far *);

int hufcod(FILE * ,image , FILE *, int , int , int );

int sendToOutput(FILE *,char far*,int *,unsigned char *);

int huftree(vector,SPOINTER *,struct symbol far**,int);

int initialize(SPOINTER *,struct symbol far**, vector,int);

int find2min(SPOINTER *,int *,int);

SPOINTER merge(SPOINTER *,int *);

int decode_huffman(FILE *,image,SPOINTER,struct symbol far*,int,int);

int reconstr_tree(FILE *,struct symbol far**,SPOINTER*,int);



int lzw(image,FILE*,int,int, int, int);

init_lzw(int,int,int*,int far*,int far*,int*,int*,int*,LPOINTER*);

int inT(int far*,int far*,int,unsigned char,int,LPOINTER*);

int AddToTable(int far*,int,int,int far*,int,int*,int*,int*,int,LPOINTER*);

int send2output(FILE*,int,int,int*,unsigned char*,

         unsigned int*,unsigned char*);

int invlzw(FILE*,image,int,int,int,int);

init_invlzw(int,int,int*,int far* far*,int*,int*);

int GetNextCode(int*,int,FILE*,unsigned char*,int*,

        int,int*,int*,unsigned int*,unsigned char*);

int AddEntry(int far* far*,int,int,int*,int*,int*,int);

int WriteString(int far* far*,int,int*,int*,int,int,image);





int arcoefficients(image,int,int,int,int,int,float [],float *);

arsolve(float far* far*,float *,float *, int,int); /*internal use*/

float corsample(image,image,int,int,int,int); /*internal use*/



/*-------------------------------------------------------------------------*/

/* Subroutines in edge20.c                                                  */



int compass(image,image, int, int,int,int,int);

int laplace(image,image, int,int,int,int);

int line_detect(image,image, int, int,int,int,int);

int point_detect(image,image, int,int,int,int);

int prewitt(image,image, int,int,int,int);

int range(image,image, int,int, int,int,int,int);

int roberts(image,image, int,int,int,int);

int sobel(image,image, int,int,int,int);



int hough(image,imatrix,int,int,int,int,float *, float *);

int thres_par(int far* far*,int,int,int);

int ihough(image,image,imatrix,int,int,int,int,float *,float *);

int look_up_table(float *,float *,int);

int edge_follow(image,image,int,int,int,int,int);

int initialize_index(CPIXEL*);

int edge_dynamic_prog(CPIXEL,CPIXEL,image,int,CPIXEL*,CPIXEL,NODE far**);

int calculate_Fx(image,CPIXEL,int,CPIXEL*,CPIXEL);

int sort_pixel(CPIXEL*);

int stack2image(NODE far**,image);

int find_direction(CPIXEL,CPIXEL);

int modified_heuristic_edge_search(CPIXEL,CPIXEL,image,int,CPIXEL*,CPIXEL,

NODE far**);

int find_successors(image,CPIXEL,int,CPIXEL*,CPIXEL);



/*-------------------------------------------------------------------------*/

/* Subroutines in list20.c                                                  */



void push(NODE far**,CPIXEL);

CPIXEL pop(NODE far**);



CHNODE *getchnode();

CHNODE *addchnode(byte, CHNODE *);

CHNODE *searchch(byte, CHAIN);

deletech(CHNODE *, CHNODE *);



LNODE *getnode();

LNODE *search();

LNODE *add_list();

     delete();

     print_list();

     fprint_list();



/*-------------------------------------------------------------------------*/

/* Subroutines in region20.c                                                  */



int count(image,int *,vector,int,int,int,int);

int grass_fire(image,int,int, float far *,int,int,int,int);

int mode_filter(image,image, int,int, int,int,int,int);

int segm(image,image, int, int,int,int,int);

int grass_label(image,image,int *,vector,int,int,int,int,int);

int grass(image,image,int,int,int, float far*,int,int,int,int);/*internal use */

int region_grow(image,image,int,int,int,int,int,int);

int region_merge(image,image,int,int,int,int,int,int);

int region_split(image,image,int,int,int,int,int *,int);

int test_homogeneity(image,int,int,int,int,int);

int region_split_merge(image,image,unsigned char far*,

               int,int,int,int,int *,int,int);

int rmerge(image,image,unsigned char far*,int,int,int,int,int *,int);

int region_split_merge_c(image,image,unsigned char far*,int **,

               int,int,int,int,int *,int,int);

int rmerge_c(image,image,unsigned char far*, int **,

                       int,int,int,int,int *,int);



float meanvalu(vector);

float varianc(vector);

float skewnes(vector);

float kurtosi(vector);

float entrop(vector);



int difhist(image,vector,int,int,int,int,int,int);

float acs(vector);

float entropy_d(vector);

float m_d(vector);



int runlen(image,imatrix,int,int,int,int,int);



double T_R(imatrix);

double sre(imatrix);

double lre(imatrix);

double gld(imatrix);

double rld(imatrix);

double rp(imatrix);



int glcmarr(image,matrix,int,int,int,int,int,int);

float c_glcm(matrix);

float asm_glcm(matrix);

float idm_glcm(matrix);

float entropy_glcm(matrix);

float corr_glcm(matrix,float *,float *);



int psRtheta(matrix,vector,vector,int,int,int);



/*-------------------------------------------------------------------------*/

/* Subroutines in shape20.c                                                */



int findch(image, int, float*,float*,float*,float*,float*, int,int,int,int);



int chain_code(image, CHAIN *, int *, int *,int,int,int,int,int);

int chain_decode(image,CHAIN,int,int,int,int,int,int);

CHAIN compress_chain(CHAIN);

CHAIN decompress_chain(CHAIN);



int curve_split(PIXEL *, LIST *, int, double);

int curve_merge(PIXEL *, LIST *, int, double);

double dist(int,int,int,int,int,int); /* internal use */

int create_curve(image, PIXEL *, int *, int,int,int,int,int);



int image2fd(image,vector,vector,int*,int,int,int,int,int);

int fd2image(vector,vector,image,int,int,int,int,int,int);



int image_to_quadtree(image,int,int,int,int, QNODE **);

int construct_quadtree(image, QNODE **, unsigned char, unsigned char *,int,int,int,int);

int find_level(QNODE *,int *);

int quadtree_to_image(QNODE *,image,int,int,int,int);

int make_image(QNODE *,image,int,int,int,int,int);

QNODE *create_node(QNODE *, unsigned char, unsigned char);



int pyramid_1(image,image,int,int);

pyramid pyramid_alloc(int);

int pyramid_free(pyramid,int);

int pyramid_fill(image,pyramid,int);

int pyramid_edge_detection(pyramid,pyramid,int,int,int);

int edge_detector(image,int,int);

int refine(pyramid,pyramid,int,int,int,int,int);



/*float find_moment(image,int,int,int,int,int,int,float,float);*/

int calc_features_1(image,int,int,int,int,float *,float *,float *,float *,

            float *,float *,float *);

int turtle_follow(image,LIST *,int,int,int,int);

float find_perimeter(LIST);

float find_bending_energy_sum(LIST);

/*int calc_features_2(LIST,float *,float *,float *,float *,float *, float);*/



int thin_1(image,int,int,int,int);

int thin_2(image,int,int,int,int);



