#define TEST
/****************************************************/
/* Install Keyboard Interrupt 09H ISR				*/
/*													*/
/*	- blocks keyboard sequences to address program	*/
/*	  interruption by inexperienced operators		*/
/*	- chains to the existing int 09H vector			*/
/*	- first call to int09H() installs new ISR		*/
/*	- second call to int09H() de-installs new ISR	*/
/*	  (resets the vector)							*/
/*													*/
/*		M. Watson	15 Oct 98						*/
/*													*/
/*	Micro-C/PC compiler command: cc int09h -fop		*/
/****************************************************/

void int09H(void)
{
	static char install_handler = -1;	/* Flag to load/unload */

	if(install_handler) {					/* install new int 09H ISR */
		install_handler = 0;
		asm {
			push	ds
			push	es
			;
			mov		ax,3509h				;get int 09H vector
			int		21h
			mov		cs:int09_O,bx			;save offset
			mov		cs:int09_S,es			;save segment
			;
			mov		ax,cs					;get segment to handler
			mov		ds,ax
			mov		dx,OFFSET cs:int09isr	;get offset to handler
			mov		ax,2509h				;set int 09H vector
			int		21h
			;
			pop		es
			pop		ds
		}
	}
	else {								/* remove installed ISR */
		install_handler = -1;
		asm {
			push	ds
			;
			mov		dx,cs:int09_O			;get offset to handler
			mov		ds,cs:int09_S			;get segment to handler
			mov		ax,2509h				;set int 09H vector
			int		21h
			;
			pop		ds
		}
	}
}

/*
 * new int 09H ISR
 */
asm {
;storage for int 09H vector
;
int09_V	LABEL	DWORD	;saved int 09 vector
int09_O	DW		?		;offset
int09_S	DW		?		;segment
;
;int 09H ISR code
;
int09	PROC	FAR
int09isr:
		push	ds
		push	ax
;
		xor		ax,ax					;analyze keyboard flags
		mov		ds,ax
		and		BYTE PTR ds:[496h],0FEH ;mask off Pause key
		mov		al,BYTE PTR ds:[417h]	;get keyboard flags
;
		and		al,0Ch
		cmp		al,0Ch					;control-alt?
		jz		CheckDel
;
		cmp		al,04h					;control only?
		jnz		ChainVect
;
		in		al,60h					;read key
		and		al,7Fh
;
		cmp		al,2Eh					;control C?
		jz		Flush_It
;
		cmp		al,46h					;control break?
		jz		Flush_It

ChainVect:
		pop		ax
		pop		ds
		jmp		cs:[int09_V]			;chain to int 09H

CheckDel:
		in		al,60h					;read key
		and		al,7Fh
		cmp		al,53h					;DEL?
		jnz		ChainVect

Flush_It:
		in		al,61H					;get keyboard control port value
		mov		ah,al
		or		al,80h					;set enable kbd bit
		out		61H,al
		xchg	ah,al					;set original control port value
		out		61H,al
		mov		al,20H					;send EOI signal
		out		20H,al					; to the 8259 Interrupt Controller
;
		pop		ax
		pop		ds
		iret

int09	ENDP
}

#ifdef TEST
/*
 * Test program - added by Dave Dunfield
 *
 * Install handler, count to 10 slowly so user can try BREAK
 * then deinstall handler and count to 10 again.
 */
#include <stdio.h>
main()
{
	int i;
	int09H();
	printf("Installed! - Try hitting BREAK.\n");
	for(i=0; i < 10; ++i) {
		printf("A number is: %u\n", i);
		delay(500); }

	int09H();
	printf("Deinstalled! - Try BREAK now.\n");
	for(i=0; i < 10; ++i) {
		printf("A number is: %u\n", i);
		delay(500); }
}
#endif
