/*
 * Display a OPUS/MAXIMUS format BBS directory listing, using FILES.BBS
 * in the format: filename.ext Description
 *
 * This program adds the file date and sizes by examining the actual files
 * in the directory, and outputs the listing in exactly the same format as
 * Maximus 2.0. I use this to get local directories of my files areas when
 * working on the BBS
 *
 * Copyright 1995-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc bdir -fop
 */
#include <stdio.h>
#include <file.h>

#define	WIDTH	48		/* Description output width */

char *ptr;
skip_blanks()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

main()
{
	int i, h, l, d, a;
	char inline[500], name[50], long1[4], long2[4];
	FILE *fp;

	fp = fopen("FILES.BBS", "rvq");
	while(fgets(ptr = inline, sizeof(inline)-1, fp)) {
		if(isspace(*ptr) || !*ptr) {
			fputs(inline, stdout);
			putc('\n', stdout);
			continue; }
		while((i = *ptr) && !isspace(i))
			++ptr;
		*ptr++ = 0;
		printf("%-13s", inline);
		if(!i) {
			printf("*** Invalid entry\n");
			continue; }
		if(find_first(inline, 0x3F, name, &h, &l, &a, &i, &d)) {
			printf("*** Offline\n");
			continue; }
		if(a & DIRECTORY)
			strcpy(name, "<DIR>");
		else {
			longset(long2, 0);
			long2[2] = 1;
			longset(long1, h);
			longmul(long1, long2);
			longset(long2, l);
			longadd(long1, long2);
			ltoa(long1, name, 10); }
		printf("%7s ", name);
		printf("%02u-%02u-%02u  ",
			d & 0x1F,
			(d >> 5) & 0x0F,
			(((d >> 9) & 0x7F)+80) % 100);
		l = 0;
		while(skip_blanks()) {
			i = 0;
			while(*ptr && !isspace(*ptr))
				name[i++] = *ptr++;
			name[i] = 0;
			if((i+l+1) > WIDTH) {
				printf("\n%31s", "");
				l = 0; }
			else if(l) {
				++l;
				putc(' ', stdout); }
			l += i;
			fputs(name, stdout); }
		putc('\n', stdout); }

	fclose(fp);
}
