/*
 * Program to time the execution of a DOS command
 *
 * Copyright 1991-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc timeit -fop
 */
#include <stdio.h>

char timestamp[4], char command[129];

main(int argc, char *argv[])
{
	int i;
	char *ptr;

	if(argc < 2)
		abort("\nUse: timeit <command>\n\nCopyright 1991-2003 Dave Dunfield\nAll rights reserved.\n");

	/* concatinate all arguments into a single string */
	ptr = command;
	for(i = 1; i < argc; ++i) {
		ptr=stpcpy(ptr, argv[i]);
		*ptr++ = ' '; }
	*--ptr = 0;

	startimer(timestamp);			/* Record initial time */
	system(command);				/* Execute the command */
	elapsed(timestamp);				/* Calculate elapsed time */

	printf("Elapsed time: %02d:%02d:%02d.%02d",
		timestamp[1], timestamp[0], timestamp[3], timestamp[2]);
}

/*
 * Record system time for later calculation
 */
startimer() asm
{
		MOV		AH,2CH		; Get time function
		INT		21H			; Ask DOS
		MOV		SI,4[BP]	; Get pointer to timestamp
		MOV		[SI],CX		; Record hours & minites
		MOV		2[SI],DX	; Record seconds & hundreds
}

/*
 * Calculate elapsed time since timestamp recorded
 */
elapsed() asm
{
		MOV		AH,2CH		; Get time function
		INT		21H			; Ask DOS
		MOV		SI,4[BP]	; Pointer to timestamp
		SUB		DL,2[SI]	; Convert 100ths
		JNC		ELAP1		; No borrow
		ADD		DL,100		; Re-adjust
		DEC		DH			; Reduce seconds
ELAP1:	MOV		2[SI],DL	; Save elapsed hundreds
		SUB		DH,3[SI]	; Convert seconds
		JNS		ELAP2		; No borrow
		ADD		DH,60		; Re-adjust
		DEC		CL			; Reduce minites
ELAP2:	MOV		3[SI],DH	; Save elapsed seconds
		SUB		CL,[SI]		; Convert minites
		JNS		ELAP3		; No borrow
		ADD		CL,60		; Re-adjust
		DEC		CH			; Adjust hours
ELAP3:	MOV		[SI],CL		; Save elapsed minites
		SUB		CH,1[SI]	; Convert hours
		MOV		1[SI],CH	; Save elapsed hours
}
