/*
 * Utility to capture all TTY output to a file while running a command.
 * (See REDIRECT.TXT for detailed information on this program)
 *
 * Copyright 1995-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted to use for personal (non-commercial) use only.
 *
 * Compile command: cc routput -fop
 */
#include <stdio.h>

#define	BUFSIZE	32767		/* Largest possible signed integer */

char help_message[] = { "\n\
Use: routput filename command...\n\n\
Captures TTY output of a command to a file. All output via to INT10-0Eh\n\
is held in a 32K buffer, and written to the named file after the command\n\
completes.\n\n\
If the command generates more than 32K of output, the remainder is lost.\n\n\
Copyright 1995-2003 Dave Dunfield\n\
All rights reserved.\n" };

unsigned char buffer[BUFSIZE];
unsigned bptr = 0;

main(int argc, char *argv[])
{
	int i;
	char command[256], *ptr;
	FILE *fp;

	/* Test for filename and at least one command argument */
	if(argc < 3)
		abort(help_message);

	/* Concatinate multiple arguments into a single command line */
	ptr = stpcpy(command, argv[i = 2]);
	while(++i < argc) {
		*ptr++ = ' ';
		ptr = stpcpy(ptr, argv[i]); }

	/* Install out output handler and execute command */
	grab_int10();
	system(command);
	release_int10();

	/* Write out contents of buffer to file */
	fp = fopen(argv[1], "wvqb");
	fput(buffer, bptr, fp);
	fclose(fp);
}

/*
 * Grab the int 10 vector & get ready for the fun
 */
grab_int10() asm
{
		MOV		AX,3510h		; Get interrupt 10
		INT		21h				; Call DOS
		MOV		CS:int10o,BX	; Save offset
		MOV		CS:int10s,ES	; Save segment
		MOV		AX,2510h		; Set interrupt 10
		MOV		DX,OFFSET int10	; Get offset
		INT		21h				; Set the segment
}

/*
 * Release the int10 vector
 */
release_int10() asm
{
		PUSH	DS				; Save DS
		MOV		AX,2510h		; Set interrupt 10
		MOV		DX,CS:int10o	; Get offset
		MOV		DS,CS:int10s	; Get segment
		INT		21h				; Call DOS
		POP		DS				; Restore DS
}

/*
 * Interrupt 10 handler
 */
asm {
int10:	CMP		AH,0Eh			; Write character in TTY
		JNZ		int12			; No, process normally
		PUSH	BX				; Save BX
		PUSH	DS				; Save DS
		MOV		BX,CS			; Get CS
		MOV		DS,BX			; Set new DS
		MOV		BX,DGRP:_bptr	; Get input pointer
		CMP		BX,BUFSIZE		; In range?
		JAE		int11			; No, ignore
		MOV		DGRP:_buffer[BX],AL; Write character
		INC		BX				; Advance
		MOV		DGRP:_bptr,BX	; Save new pointer
int11:	POP		DS				; Restore DS
		POP		BX				; Restore BX
; If you do not want the command output to appear on the tty,
; uncomment (remove ; from) the following line.
;		IRET
int12:	DB		0EAh			; Intersegment jummp
int10o	DW		0				; Offset
int10s	DW		0				; Segment
}
