/*
 * "Quick and Dirty" TSR to override the DOS date.
 *
 * Intercepts Int-21 Function-2A and returns the user specified date
 * instead of the current one.
 *
 * If deployed within a Win95 DOS box, only that box will be affected.
 *
 * I have not provided an "unload" function (the TSR will disappear when
 * the W95 DOS box is closed) or extensive checking of the validity of
 * the specified replacement date ... these are left as "an excersise
 * for the reader".
 *
 * Copyright 2001-2003 Dave Dunfield
 * Freely distributable.
 *
 * Compile command: cc fixdate -fop
 */
#include <stdio.h>		// Standard I/O definitions
#include <file.h>		// For low-level output functions
#include <tsr.h>		// For tsr() function

/*
 * Global data - set by main program, read by Int21 handler
 */
unsigned char
	day,		// day to report
	month,		// month to report
	dow;		// day of week to report

unsigned
	year;		// year to report

// Help message shown on any command syntax error
static char help_msg[] = { "\n\
Use: FIXDATE day(1-31) month(1-12) year(0-9999)\n\n\
Copyright 2001-2003 Dave Dunfield - Freeware.\n" };

/*
 * Calculate the day of the week for a given date
 */
static unsigned calc_dow(unsigned y, unsigned m, unsigned d)
{
	return (3*y - (7*(y+(m+9)/12))/4 + (23*m)/9 + d + 2) % 7;
}

/*
 * Interrupt 21 handler - Intercept function 2A (get date),
 * otherwise just far-jump to old vector.
 */
asm {
int21:	CMP		AH,2Ah			; Get date function?
		JZ		xdate			; Special case
		DB		0EAh			; Far JMP opcode
into:	DW		0				; Interrupt offset
ints:	DW		0				; Interrupt segment
;
; "get date" request
; - set DS so we can access 'C' DGRP
; - load date information to report
; - restore DS and return to caller
;
xdate:	PUSH	DS				; Save DS
		MOV		CX,CS			; Get CS
		MOV		DS,CX			; Set DS
		MOV		CX,DGRP:_year	; Get year
		MOV		DH,DGRP:_month	; Get month
		MOV		DL,DGRP:_day	; Get day
		MOV		AL,DGRP:_dow	; Day of week
		POP		DS				; Restore DS
		IRET					; And return
}

/*
 * Save the old DOS Int21 vector in the handlers JMP instruction
 * operands, then install a new vector to point to the handler.
 */
static void get_vector() asm
{
; Get old vector and patch handlers "JMP" instruction
		MOV		AX,3521h		; Get vector 21
		INT		21h				; Ask DOS
		MOV		word ptr ints,ES ; Patch segment
		MOV		word ptr into,BX ; Patch offset
; Direct handler to our vector
		MOV		DX,offset int21	; Get offset of handler
		MOV		AX,2521h		; Set vector 21
		INT		21h				; Ask DOS
}

/*
 * This function is not used since our "Quick and Dirty" TSR has
 * no unload function ... however this is how we would restore the
 * original Int21 vector.
 *
static void restore_vector() asm
{
		PUSH	DS				; Save DS
		MOV		DX,word ptr into ; Get original offset
		MOV		DS,word ptr ints ; Get original segment
		MOV		AX,2521h		; Set vector 21
		INT		21h				; Ask DOS
		POP		DS				; Restore DS
} */

/*
 * Dummy target for tsr() function hotkey handler ...
 * this should never get called, however if the tsr() function
 * were to immagine for some reason that it's hotkeys had been
 * pressed, this would do nothing...
 */
static void hotkey_func()
{
}

/*
 * Main program
 */
main(int argc, char *argv[])
{
	// Parse command line arguments
	if(argc != 4) {
		help: lputs(help_msg, L_stderr);
		return; }
	day = atoi(argv[1]);
	month = atoi(argv[2]);
	year = atoi(argv[3]);
	if((day < 1) || (day > 31) || (month < 1) || (month > 12) || (year > 9999))
		goto help;

	// Calculate correct day-of-week for entered date
	dow = calc_dow(year, month, day);

	// Take over Int21 vector to intercept function 2A (get date)
	get_vector();

	// terminate-and-stay-resident - No hotkeys, 128 bytes of stack
	tsr(&hotkey_func, -1, 128);
}
