;
; NorthStar Transfer (NST) disk access client with embedded DOS
; For SINGLE DENSITY controller
;
; This is a version of the NST client which includes the active
; portion of NorthStar DOS 5.0, so that you can make disk images
; even if you do not have a bootable NorthStar disk system.
; 
; You must supply host I/O functions to perform raw 8-bit serial
; data transfer with your console I/O hardware - please refer to
; the "Host I/O functions" section at the end of this file.
;
; NST permits comms parameters which are NOT 8-bit, however this
; is only for use with the UB and UH functions (if required) - all
; disk image transfer function (RS, RD, WS, WD) *REQUIRE* 8-bit
; serial I/O.
;
; This code MUST load into memory at address $2000, which is the
; origin of the NorthStar DOS image. Once loaded, you MUST launch
; it via a jump to $2900.
;
; The DBUF symbol defines a disk I/O buffer which is normally up to
; 32k in size, starting at $2C00 If you do not have enough memory for
; a 32k buffer, you can force NST to use a smaller buffer with the
; 'B=' option. If this option is not used, NST will attempt to pick
; an "optimal" buffer size which is an integral number of tracks that
; fits within 32k.
;
; Assemble with DDS ASM80 assembler: ASM80 NSTXS -T
;
; The resultant NSTXS.HEX file must be transferred to the NorthStar
; system - NST provides a 'UH' (Upload Hex) function which can do
; this by "typing the code in" to most debug monitors:
;
; Example loading under CP/M DDT:
;
;  Connect the PC serial port to the NorthStar system console port.
;
;  Execute the command: NST UH NSTXS.HEX U=2'~s'~R  [C= if needed]
;  You will be presented with a terminal on the CP/M system.
;
;  Boot CP/M and get to the A> prompt.
;
;  Run DDT: DDT
;
;  Enter the DDT command: S2000
;  You should see a prompt with the first memory location.
;
;  Press F1 - NST will now "type in" the NSTXS disk stub code.
;
;  When it stops, press . then ENTER to return to the DDT prompt.
;
;  Enter the DDT command: G2900
;
;  The client should activate and you should see the message "NST"
;  displayed on the terminal. Press F10 to exit the upload terminal
;  function - you may now use NST to read and write disk images.
;
; Fixed EQU - DO NOT CHANGE for the NSTXS client
DOS	EQU	$2000		NorthStar DOS base address
DATA	EQU	$2BC0		NST Data area (64 bytes)
DBUF	EQU	$2C00		NST disk I/O buffer (32k)
;
; OS entry points - derived from 'DOS' above - should not be altered
DCOM	EQU	DOS+$22		Disk access subroutine
;
; Data storage
	ORG	DATA		Data area
SECTOR	DS	2		Sector number
UNIT	DS	1		Unit number
BLOCKS	DS	1		# vlocks
STACK	EQU	DATA+64		Stack position
; Active (saved from in-memory) NorthStar Single-Density DOS image
	ORG	DOS
	FCB	$22,$59,$59,$01,$C3,$7B,$20,$C3,$11,$27,$C3,$40,$27,$C3,$29,$29
	FCB	$C3,$16,$29,$C3,$00,$29,$C3,$32,$29,$C3,$05,$21,$C3,$88,$24,$C3
	FCB	$4A,$23,$C3,$C4,$23,$C3,$8A,$21,$C3,$C2,$20,$01,$C3,$FA,$20,$00
	FCB	$01,$7D,$27,$18,$00,$43,$4F,$50,$59,$52,$49,$47,$48,$54,$20,$4E
	FCB	$4F,$52,$54,$48,$20,$53,$54,$41,$52,$20,$43,$4F,$4D,$50,$55,$54
	FCB	$45,$52,$53,$2C,$20,$49,$4E,$89,$E9,$37,$E9,$3B,$E9,$CB,$E9,$BF
	FCB	$25,$DD,$20,$0D,$0A,$4E,$4F,$52,$54,$48,$20,$53,$54,$41,$52,$20
	FCB	$44,$4F,$53,$20,$35,$2E,$31,$53,$0D,$0A,$22,$31,$63,$20,$3E,$05
	FCB	$01,$01,$00,$11,$01,$05,$21,$00,$21,$CD,$1E,$E9,$C2,$7B,$20,$3E
	FCB	$04,$01,$01,$01,$11,$01,$00,$21,$00,$26,$CD,$1E,$E9,$C2,$7B,$20
	FCB	$3E,$59,$32,$01,$20,$32,$02,$20,$CD,$13,$20,$11,$63,$20,$1A,$FE
	FCB	$22,$CA,$BB,$20,$CD,$BC,$26,$13,$C3,$AE,$20,$3A,$30,$20,$B7,$CA
	FCB	$DD,$20,$31,$63,$20,$21,$05,$21,$22,$1A,$20,$21,$FA,$20,$22,$2D
	FCB	$20,$AF,$32,$A1,$28,$06,$2A,$CD,$B6,$26,$CD,$B5,$25,$21,$7F,$27
	FCB	$22,$B7,$28,$2A,$7D,$27,$EB,$21,$36,$21,$06,$0B,$CD,$09,$27,$23
	FCB	$23,$CA,$2D,$21,$23,$23,$05,$C2,$EC,$20,$06,$3F,$CD,$B6,$26,$CD
	FCB	$C1,$26,$C3,$C2,$20,$F5,$3E,$54,$CD,$BC,$26,$F1,$C6,$30,$CD,$BC
	FCB	$26,$CD,$B4,$26,$3E,$44,$CD,$BC,$26,$79,$C6,$30,$CD,$BC,$26,$CD
	FCB	$B4,$26,$3E,$53,$CD,$BC,$26,$CD,$82,$26,$C3,$FF,$20,$CD,$D0,$26
	FCB	$EB,$11,$C2,$20,$D5,$E9,$43,$52,$6E,$22,$44,$45,$62,$21,$47,$4F
	FCB	$BF,$21,$4A,$50,$B5,$21,$52,$44,$3C,$22,$57,$52,$41,$22,$49,$4E
	FCB	$BB,$22,$4C,$49,$6E,$21,$54,$59,$E2,$21,$4C,$46,$11,$22,$53,$46
	FCB	$16,$22,$CD,$EB,$22,$CD,$02,$27,$CD,$40,$23,$C3,$4A,$23,$2A,$B7
	FCB	$28,$7E,$23,$FE,$20,$CA,$71,$21,$FE,$23,$3E,$00,$C2,$86,$21,$7E
	FCB	$23,$22,$B7,$28,$E6,$07,$6F,$CD,$D5,$26,$CD,$E7,$26,$7D,$32,$A1
	FCB	$28,$3A,$33,$20,$32,$B6,$28,$3E,$01,$C3,$99,$24,$50,$52,$45,$53
	FCB	$53,$20,$52,$45,$54,$55,$52,$4E,$20,$54,$4F,$20,$43,$4F,$4E,$54
	FCB	$49,$4E,$55,$45,$07,$CD,$0A,$26,$E5,$2A,$B7,$28,$3E,$20,$C9,$CD
	FCB	$EB,$22,$4F,$CD,$D0,$26,$D5,$CD,$D0,$26,$7E,$23,$FE,$01,$C2,$2C
	FCB	$20,$7B,$CD,$D0,$26,$E1,$D5,$06,$01,$CD,$22,$20,$2A,$B7,$28,$3E
	FCB	$20,$C9,$CD,$EB,$22,$11,$04,$00,$19,$E5,$CD,$40,$26,$DA,$2C,$20
	FCB	$7C,$B7,$C2,$2C,$20,$7D,$B7,$FA,$2C,$20,$E1,$77,$FE,$01,$C2,$0B
	FCB	$22,$E5,$CD,$0A,$26,$EB,$E1,$23,$CD,$CB,$26,$CD,$02,$27,$C3,$4A
	FCB	$23,$06,$01,$C3,$18,$22,$06,$00,$C5,$CD,$EB,$22,$C1,$3A,$AC,$28
	FCB	$4F,$C5,$CD,$D0,$26,$D5,$CD,$D0,$26,$7B,$F5,$CD,$0A,$26,$EB,$CD
	FCB	$02,$27,$F1,$E1,$C1,$CD,$22,$20,$DA,$2C,$20,$C9,$06,$01,$C3,$43
	FCB	$22,$06,$00,$CD,$40,$26,$DA,$2C,$20,$E5,$0E,$01,$FE,$20,$CA,$59
	FCB	$22,$FE,$2C,$C2,$2C,$20,$CD,$D5,$26,$CD,$0A,$26,$E5,$CD,$40,$26
	FCB	$7D,$D1,$E1,$C3,$35,$22,$20,$20,$20,$20,$20,$20,$20,$20,$CD,$F8
	FCB	$22,$CD,$98,$24,$D2,$2C,$20,$E5,$11,$66,$22,$CD,$98,$24,$DA,$2C
	FCB	$20,$E3,$E5,$CD,$40,$26,$DA,$2C,$20,$E3,$CD,$40,$26,$CD,$02,$27
	FCB	$EB,$21,$A1,$FE,$C1,$09,$DA,$2C,$20,$19,$DA,$2C,$20,$E1,$E5,$CD
	FCB	$CB,$26,$71,$23,$70,$23,$36,$00,$23,$71,$E1,$11,$AB,$28,$06,$08
	FCB	$2B,$1A,$77,$1B,$05,$C2,$B0,$22,$C3,$4A,$23,$CD,$D5,$26,$4F,$06
	FCB	$FF,$21,$9D,$27,$AF,$36,$20,$23,$3D,$C2,$C5,$22,$3E,$23,$21,$00
	FCB	$00,$F5,$3E,$0A,$C5,$E5,$11,$9D,$27,$CD,$22,$20,$DA,$2C,$20,$E1
	FCB	$01,$0A,$00,$09,$C1,$F1,$3D,$C2,$D1,$22,$C9,$CD,$F8,$22,$DA,$2C
	FCB	$20,$CD,$98,$24,$DA,$2C,$20,$C9,$3E,$01,$32,$AC,$28,$06,$08,$21
	FCB	$AC,$28,$2B,$36,$20,$05,$C2,$02,$23,$54,$5D,$CD,$F2,$26,$37,$C8
	FCB	$FE,$20,$CA,$0B,$23,$FE,$2C,$37,$C8,$06,$08,$C8,$FE,$20,$C8,$FE
	FCB	$2C,$CA,$2F,$23,$05,$37,$F8,$77,$23,$CD,$F2,$26,$C3,$1B,$23,$CD
	FCB	$D5,$26,$CD,$F2,$26,$FE,$20,$C8,$FE,$0D,$C8,$37,$C9,$21,$AC,$28
	FCB	$06,$08,$2B,$36,$20,$05,$C2,$42,$23,$C9,$3A,$AC,$28,$4F,$3A,$AE
	FCB	$28,$6F,$26,$00,$06,$00,$11,$9D,$27,$3E,$01,$CD,$22,$20,$DA,$2C
	FCB	$20,$C9,$7B,$B7,$C2,$BF,$23,$3A,$2B,$20,$B7,$CA,$BF,$23,$E1,$F1
	FCB	$3A,$78,$27,$1E,$02,$32,$78,$27,$3E,$0A,$F5,$E5,$D5,$C5,$3A,$78
	FCB	$27,$CD,$1E,$E9,$32,$7A,$27,$78,$32,$79,$27,$C1,$D1,$CA,$62,$23
	FCB	$E1,$3A,$7A,$27,$FE,$04,$D2,$9E,$23,$F1,$3D,$C2,$7A,$23,$2A,$7B
	FCB	$27,$F9,$3A,$78,$27,$21,$79,$27,$96,$82,$68,$26,$00,$29,$54,$5D
	FCB	$29,$29,$19,$85,$6F,$7C,$CE,$00,$67,$3A,$7A,$27,$C3,$19,$20,$D1
	FCB	$D1,$C3,$CE,$E9,$E5,$21,$04,$00,$39,$22,$7B,$27,$E1,$D5,$C5,$F5
	FCB	$E5,$B7,$CA,$38,$24,$11,$A2,$FE,$19,$DA,$38,$24,$5F,$16,$00,$1B
	FCB	$19,$DA,$38,$24,$79,$FE,$01,$DA,$38,$24,$FE,$04,$D2,$38,$24,$78
	FCB	$FE,$01,$CA,$3E,$24,$FE,$02,$CA,$3E,$24,$FE,$00,$21,$00,$00,$CA
	FCB	$0A,$24,$FE,$FF,$21,$00,$FF,$C2,$38,$24,$22,$B4,$28,$3A,$90,$EB
	FCB	$E6,$10,$C2,$1D,$24,$16,$32,$CD,$D0,$E9,$C3,$24,$24,$3A,$03,$20
	FCB	$B9,$CA,$30,$24,$06,$EB,$0A,$79,$32,$03,$20,$16,$0D,$CD,$D0,$E9
	FCB	$3A,$10,$EB,$E6,$02,$CA,$3E,$24,$E1,$F1,$C1,$D1,$37,$C9,$E1,$F1
	FCB	$11,$F6,$FF,$06,$FF,$04,$19,$DA,$45,$24,$85,$D2,$7A,$24,$CA,$7A
	FCB	$24,$67,$7D,$C6,$0A,$57,$D6,$0B,$2F,$32,$79,$27,$68,$22,$9D,$28
	FCB	$E1,$22,$9F,$28,$4D,$5C,$E1,$CD,$75,$23,$E5,$2A,$9F,$28,$E5,$2A
	FCB	$9D,$28,$7C,$45,$04,$2E,$F6,$C3,$4A,$24,$95,$F5,$7D,$C6,$0A,$57
	FCB	$F1,$E1,$5C,$4D,$E1,$C3,$75,$23,$22,$B7,$28,$32,$AC,$28,$7E,$FE
	FCB	$20,$11,$66,$22,$C4,$FD,$22,$D8,$AF,$32,$AD,$28,$32,$AF,$28,$22
	FCB	$B0,$28,$21,$5F,$01,$22,$B2,$28,$21,$04,$00,$22,$A2,$28,$01,$00
	FCB	$04,$EB,$E5,$C5,$CD,$C7,$24,$C1,$D1,$3A,$AC,$28,$C8,$0C,$05,$C2
	FCB	$B1,$24,$37,$2A,$A2,$28,$C9,$E5,$26,$00,$69,$11,$9D,$27,$79,$32
	FCB	$AE,$28,$3A,$AC,$28,$4F,$06,$01,$3E,$01,$CD,$22,$20,$21,$9D,$27
	FCB	$06,$10,$D1,$D5,$E5,$0E,$08,$3A,$AD,$28,$B7,$C2,$2E,$25,$1A,$BE
	FCB	$C2,$FD,$24,$13,$23,$0D,$C2,$EE,$24,$C1,$C1,$AF,$C9,$E1,$E5,$7E
	FCB	$FE,$20,$CA,$21,$25,$C5,$11,$08,$00,$19,$CD,$D0,$26,$4E,$23,$46
	FCB	$EB,$09,$EB,$21,$A2,$28,$CD,$09,$27,$C1,$DA,$21,$25,$EB,$22,$A2
	FCB	$28,$E1,$11,$10,$00,$19,$D1,$05,$C2,$E3,$24,$AF,$3C,$C9,$7E,$FE
	FCB	$20,$CA,$21,$25,$C5,$3A,$A1,$28,$B7,$C2,$6B,$25,$3A,$B6,$28,$B7
	FCB	$CA,$6B,$25,$3D,$C2,$68,$25,$E5,$21,$9C,$21,$46,$CD,$B6,$26,$23
	FCB	$7E,$FE,$07,$C2,$4B,$25,$CD,$10,$20,$FE,$03,$CA,$2C,$20,$FE,$0D
	FCB	$C2,$56,$25,$E1,$3A,$33,$20,$3D,$32,$B6,$28,$46,$CD,$B6,$26,$23
	FCB	$0D,$C2,$6B,$25,$CD,$B4,$26,$CD,$D0,$26,$E5,$EB,$CD,$82,$26,$CD
	FCB	$B4,$26,$E1,$CD,$D0,$26,$E5,$EB,$CD,$82,$26,$CD,$B4,$26,$E1,$E5
	FCB	$6E,$26,$00,$CD,$82,$26,$E1,$7E,$FE,$01,$C2,$A8,$25,$CD,$B4,$26
	FCB	$23,$CD,$D0,$26,$EB,$CD,$6E,$26,$CD,$C1,$26,$CD,$16,$20,$C1,$C2
	FCB	$21,$25,$C3,$2C,$20,$21,$7D,$27,$11,$01,$20,$AF,$CD,$10,$20,$FE
	FCB	$03,$CA,$CE,$25,$FE,$40,$CA,$CE,$25,$FE,$0E,$C2,$D6,$25,$06,$40
	FCB	$CD,$B6,$26,$C3,$FF,$20,$06,$5F,$FE,$5F,$CA,$E9,$25,$FE,$11,$CA
	FCB	$E9,$25,$06,$08,$FE,$08,$C2,$F5,$25,$CD,$B6,$26,$14,$1D,$CA,$FF
	FCB	$20,$2B,$C3,$BB,$25,$77,$47,$CD,$B6,$26,$FE,$0D,$06,$0A,$CA,$B6
	FCB	$26,$23,$1C,$15,$C2,$BB,$25,$C3,$FA,$20,$CD,$F2,$26,$FE,$20,$CA
	FCB	$0A,$26,$21,$00,$00,$CD,$2B,$26,$DA,$2C,$20,$29,$29,$29,$29,$85
	FCB	$6F,$CD,$F2,$26,$C8,$FE,$20,$C2,$15,$26,$C9,$FE,$30,$D8,$FE,$3A
	FCB	$D2,$36,$26,$D6,$30,$C9,$FE,$41,$D8,$FE,$47,$3F,$D8,$D6,$37,$C9
	FCB	$CD,$F2,$26,$37,$C8,$FE,$20,$CA,$40,$26,$21,$00,$00,$FE,$3A,$D2
	FCB	$2C,$20,$D6,$30,$DA,$2C,$20,$54,$5D,$29,$29,$19,$29,$5F,$16,$00
	FCB	$19,$CD,$F2,$26,$C8,$FE,$20,$C8,$FE,$2C,$C8,$C3,$4D,$26,$11,$00
	FCB	$F0,$0E,$30,$CD,$95,$26,$11,$00,$FF,$CD,$95,$26,$11,$F0,$FF,$C3
	FCB	$8D,$26,$11,$9C,$FF,$0E,$30,$CD,$95,$26,$11,$F6,$FF,$CD,$95,$26
	FCB	$11,$FF,$FF,$0E,$FF,$06,$2F,$22,$7D,$27,$04,$19,$DA,$97,$26,$2A
	FCB	$7D,$27,$78,$B9,$CA,$B4,$26,$0E,$FF,$FE,$3A,$DA,$B6,$26,$C6,$07
	FCB	$47,$C3,$B6,$26,$06,$20,$3A,$A1,$28,$C3,$0D,$20,$47,$AF,$C3,$0D
	FCB	$20,$06,$0D,$CD,$B6,$26,$06,$0A,$C3,$B6,$26,$73,$23,$72,$23,$C9
	FCB	$5E,$23,$56,$23,$C9,$0E,$01,$CD,$F2,$26,$CA,$ED,$26,$FE,$20,$CA
	FCB	$D5,$26,$D6,$30,$CA,$2C,$20,$4F,$E6,$FC,$C2,$2C,$20,$79,$32,$AC
	FCB	$28,$C9,$E5,$2A,$B7,$28,$7E,$FE,$0D,$CA,$00,$27,$23,$22,$B7,$28
	FCB	$E1,$C9,$CD,$F2,$26,$C2,$2C,$20,$C9,$23,$7A,$BE,$2B,$C0,$7B,$BE
	FCB	$C9,$06,$8C,$11,$50,$EB,$0E,$00,$3A,$10,$EB,$E6,$04,$C2,$29,$27
	FCB	$05,$C2,$18,$27,$3E,$01,$C3,$AB,$E9,$41,$1A,$BE,$3E,$03,$C2,$AB
	FCB	$E9,$23,$0D,$C2,$2A,$27,$F1,$3D,$C8,$F5,$CD,$CE,$E9,$C3,$11,$27
	FCB	$3A,$04,$EB,$3A,$10,$EB,$E6,$08,$CA,$43,$27,$01,$0F,$00,$58,$16
	FCB	$EA,$1A,$7E,$0D,$C2,$4E,$27,$1E,$FB,$1A,$7E,$7E,$5F,$A8,$07,$47
	FCB	$1A,$23,$0D,$C2,$5B,$27,$58,$03,$1A,$F1,$3D,$C8,$F5,$EB,$2A,$B4
	FCB	$28,$19,$CD,$CE,$E9,$C3,$40,$27,$00,$00,$00,$00,$00,$47,$4F,$20
	FCB	$42,$41,$53,$49,$43,$0D,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$7F,$27,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;
; Here we patch the DOS image (at assembly time) to reference our I/O functions
;
	ORG	DOS+$0D
	JMP	NOUT		; Character output
	JMP	NIN		; Character input
	JMP	HINIT		; I/O initialization
	JMP	NCTRLC		; Test for CTRL-C
	ORG	DOS+$19		; HDE handler
	JMP	RESET		; Disk Error
;
; Entry point
; Set up stack, initialize I/O and fall into the NST main loop
;
	ORG	DOS+$900
	DI			No interrupts
	LXI	SP,STACK	Init stack
	CALL	HINIT		Initialize host port
	LXI	H,HELLO		Point to startup message
	MOV	A,M		Get first character
IMSG1	INX	H		Advance
	CALL	PUTC		Display
	MOV	A,M		Get next character
	ANA	A		End of message?
	JNZ	IMSG1		No, display it all
; Command loop - wait for '$c' command and execute
TOP	LXI	SP,STACK	Reset stack
	CALL	GETC		Get command char
	CPI	'$'		Command lead-in?
	JNZ	TOP		No, wait for it
TOP1	CALL	GETC		Get command
; Read data from disk
tREAD	CPI	'R'		Read block
	JNZ	tWRITE		No, try next
	CALL	GDISK		Get disk read/write parameters
	LHLD	sector		HL = sector
	LXI	D,DBUF		DE = RAM buffer
	LDA	UNIT		Get unit
	MOV	C,A		C = unit
	MVI	B,1		Read operation
	LDA	BLOCKS		A = #blocks
	CALL	DCOM		Perform disk action
	JC	error		Report error
	CALL	PUTEQ		Indicator
	CALL	GSIZE		Get size
tr1	MOV	A,M		Read data byte
	CALL	PUTC		Write it
	INX	H		Skip to next
	ADD	C		Add to checksum
	MOV	C,A		Resave
	JNC	tr2		No carry
	INR	B		Carry in
tr2	DCX	D		Reduce count
	MOV	A,D		Get high
	ORA	E		Remaining data?
	JNZ	tr1		Do them all
	MOV	A,B		Get checksum
	CALL	PUTC		Write it
	MOV	A,C		Get checksum
putop	CALL	PUTC		Write it
	JMP	TOP
;
; Write data to disk
;
tWRITE	CPI	'W'		Write?
	JNZ	tGET		No, try next
	CALL	GDISK		Get disk parameters
	CALL	GSIZE		Get buffer size
	CALL	PUTEQ		Indicator
twr1	CALL	GETC		Get data
	MOV	M,A		Save it
	INX	H		Next position
	ADD	C		Add to checksum
	MOV	C,A		Resave
	JNC	twr2		No carry
	INR	B		Carry in
twr2	DCX	D		Reduce count
	MOV	A,D		Get high
	ORA	E		Any left?
	JNZ	twr1		Yes, do them all
	CALL	GETC		Get check H
	MOV	D,A		Save
	CALL	GETC		Get check L
	CMP	C		Match?
	JNZ	error		No, report error
	MOV	A,D		Get H
	CMP	B		Match H
	JNZ	error		Report error
	LHLD	sector		HL = sector
	LXI	D,DBUF		DE = RAM buffer
	LDA	UNIT		Get unit
	MOV	C,A		C = unit
	MVI	B,0		Write operation
	LDA	BLOCKS		A = #blocks
	CALL	DCOM		Perform disk action
	JC	error		Report error
pudot	MVI	A,'.'		Done flag
	JMP	putop		Output & exit
;
; Get byte from memory
tGET	CPI	'G'		Get?
	JNZ	tPUT		No, try next
	CALL	GMEM		Get DOS memory
	CALL	PUTEQ		Output indicator
	MOV	A,M		Get data
	JMP	putop		Output & exit
;
; Put a byte in memory
tPUT	CPI	'P'		Put?
	JNZ	tTEST		No, try next
	CALL	GMEM		Get DOS memory
	CALL	GETC		Get value
	MOV	M,A		Write value
	JMP	pudot		And exit
;
; Test for kernel present
;
tTEST	CPI	'$'		Entry again?
	JZ	TOP1		Wait for another
	CPI	'?'		Test1 ?
	JZ	pudot		handle it
	CPI	'T'		Test2 ?
	JNZ	ERROR		No, try next
	MVI	A,'*'		Response
	JMP	putop
;
; Error has occured
;
ERROR	MVI	A,'?'		Error indicator
	CALL	PUTC		Display it
RESET	CALL	GETC		Read character
	JMP	RESET		Till timeout & restart
;
; Get DOS memory address
;
GMEM	CALL	GETC		Read data
	MOV	H,A		Set high addess
	CALL	GETC		Read data
	MOV	L,A		Set low data
	LXI	D,DOS		DOS address
	DAD	D		Offset to DOS
	RET
;
; Get disk parameters from host
;
GDISK	CALL	GETC		Get data
	STA	UNIT		Set unit/density
	CALL	GETC		Get data
	STA	SECTOR+1	Set sector high
	CALL	GETC		Get data
	STA	SECTOR		Set sector low
	CALL	GETC		Get # blocks
	STA	BLOCKS		Save # blocks
	RET
;
; Get size of disk I/O buffer from saved parameters
;
GSIZE	LHLD	BLOCKS-1	H= # blocks
	MVI	L,0		Zero low (HL = blocks * 256)
	LDA	UNIT		Get unit
	ANI	$80		Double?
	JZ	gsize1		no - it's ok
	DAD	H		HL = blocks * 512
gsize1	XCHG			DE = size
	LXI	H,DBUF		Point to disk I/O buffer
	LXI	B,0		Zero BC
	RET
;
; Get character from host with timeout
;
GETC	PUSH	H		Save HL
	LXI	H,$3FFF		Init counter
getc1	CALL	TESTC		Check for character
	JNC	getc2		We have data
	DCR	L		Decrement counter
	JNZ	getc1		Keep going
	DCR	H		Decrement counter
	JNZ	getc1		Keep going
	JMP	TOP		Reset and restart
getc2	POP	H		Restore HL
	RET
;
; Write the '=' sign
;
PUTEQ	MVI	A,'='		Get indicator
	JMP	PUTC		And display
;
; NorthStar Character input function
NOUT	MOV	A,B
	JMP	PUTC
; NorthStar Character output function
NIN	CALL	TESTC
	JC	NIN
	RET
; NorthStar Test Ctrl-C function
NCTRLC	CALL	TESTC
	CPI	3
	RET
HELLO	STR	'NST'
	DB	$0A,$0D,0
;
;-------------------------------------------------------------
; Host I/O functions
;-------------------------------------------------------------
; These example functions are setup for a NorthStar Horizon.
; If required, modify them to suit your hardware. NOTE: They
; *MUST* perform 8-bit "raw" character I/O.
;
; --- DO NOT MODIFY ANY CODE ABOVE THIS LINE ---
;
; Write character in ACC to host - no registers may be modified
;
PUTC	PUSH	PSW		;Save ACC
putc1	IN	3		;Read status
	ANI	%00000001	;TX ready?
	JZ	putc1		;No, wait for it
	POP	PSW		;Restore ACC
	OUT	2		;Write to data port
	RET
;
; Test for character available from HOST
; If character is ready, return with C-flag clear and character in ACC
; If no character is ready, return with C-flag SET and ACC undefined
; No other registers may be modified.
;
TESTC	IN	3		;Read status
	ANI	%00000010	;RX ready?
	JZ	testc1		;No data
	IN	2		;Read data
	RET
testc1	STC			;Indicate no data
	RET
;
; Host initialization function
; Perform any initialization required to set the host port
; to 8-bit raw binary data mode - you may also wish to increase
; the baudrate for faster transfers.
; Called only once at NST startup - all registers may be modified.
HINIT	MVI	A,3		; Insure not setup mode
	OUT	3		; Write once
	OUT	3		; Write again (now in operate mode)
	MVI	A,%01110111	; Return to setup mode
	OUT	3		; write it
	MVI	A,%01001110	; 8 data, 1 stop, x10
	OUT	3		; Write it
	MVI	A,%00110111	; RTS,DTR,Enable RX,TX
	OUT	3		; Write it
	IN	2		; Clear pending
	IN	2		; Clear pending
	RET
