/*
 * Very simple Unix program to monitor keyboard and report sequences
 * generated by various keypresses.
 *
 * compile with: gcc showkey.c -o showkey
 */
#include <stdio.h>
#include <termios.h>
#include <fcntl.h>

main()
{
	int tty, status;
	struct termios oldkey, newkey;
	unsigned char c;


	/*
	 * Set TTY to raw input mode
	 */
	tty = open("/dev/tty", O_RDWR | O_NOCTTY | O_NONBLOCK); //set the user console port up
	tcgetattr(tty,&oldkey); // save current port settings   //so commands are interpreted right for this program
	// set new port settings for non-canonical input processing  //must be NOCTTY
	newkey.c_cflag = B38400 | CRTSCTS | CS8 | CLOCAL | CREAD;
	newkey.c_iflag = IGNPAR;
	newkey.c_oflag = 0;
	newkey.c_lflag = 0;       //ICANON;
	newkey.c_cc[VMIN]=1;
	newkey.c_cc[VTIME]=0;
	tcflush(tty, TCIFLUSH);
	tcsetattr(tty,TCSANOW,&newkey);

	printf("Press ^Z (Control-Z) to exit.\r\n");

	/*
	 * Read and echo characters
	 */
	do {
		status = fread(&c, 1, 1, stdin);
		if(c == 0x7F)
			printf("\r\n<DEL>");
		else if(c < ' ')
			printf("\r\n^%c", c+'@');
		else
			putc(c, stdout); }
	while(c != 0x1A);

	tcsetattr(tty,TCSANOW,&oldkey);
	close(tty);
}
